#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tdigest
version:              0.3.1
visibility:           public
id:                   tdigest-0.3.1-CPQavRebmOFHFqTK47SfP7
key:                  tdigest-0.3.1-CPQavRebmOFHFqTK47SfP7
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/haskell-tdigest#readme
synopsis:             On-line accumulation of rank-based statistics
description:
    A new data structure for accurate on-line accumulation of rank-based statistics such as quantiles and trimmed means.

    See original paper: "Computing extremely accurate quantiles using t-digest" by Ted Dunning and Otmar Ertl
    for more details <https://github.com/tdunning/t-digest/blob/07b8f2ca2be8d0a9f04df2feadad5ddc1bb73c88/docs/t-digest-paper/histo.pdf>.

category:             Numeric
abi:                  7c2c77a30572205766aa11c0d16fbc94
exposed:              True
exposed-modules:
    Data.TDigest Data.TDigest.Internal Data.TDigest.NonEmpty
    Data.TDigest.Postprocess Data.TDigest.Postprocess.Internal
    Data.TDigest.Tree Data.TDigest.Tree.Internal
    Data.TDigest.Tree.NonEmpty Data.TDigest.Tree.Postprocess
    Data.TDigest.Vector Data.TDigest.Vector.Internal
    Data.TDigest.Vector.NonEmpty Data.TDigest.Vector.Postprocess

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tdigest-0.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tdigest-0.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tdigest-0.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tdigest
hs-libraries:         HStdigest-0.3.1-CPQavRebmOFHFqTK47SfP7
depends:
    base-4.17.2.1 binary-0.8.9.1 deepseq-1.4.8.0
    foldable1-classes-compat-0.1.1-b72stJcCAb49xOcrO8X8T
    reducers-3.12.5-JKLtQNWWIRV4ZTJcA4Fu1f transformers-0.5.6.2
    vector-0.13.2.0-GDtmlcfK9QZ7E5AlTQVnIi
    vector-algorithms-0.9.1.0-E96jWPANLnL52vj6clGB9M

haddock-interfaces:   /usr/share/doc/haskell-tdigest/html/tdigest.haddock
haddock-html:         /usr/share/doc/haskell-tdigest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

