#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tasty
version:              1.4.3
visibility:           public
id:                   tasty-1.4.3-HawtMXzm4DS8dcW1CZQcKE
key:                  tasty-1.4.3-HawtMXzm4DS8dcW1CZQcKE
license:              MIT
maintainer:           Roman Cheplyaka <roma@ro-che.info>
author:               Roman Cheplyaka <roma@ro-che.info>
homepage:             https://github.com/UnkindPartition/tasty
synopsis:             Modern and extensible testing framework
description:
    Tasty is a modern testing framework for Haskell.
    It lets you combine your unit tests, golden
    tests, QuickCheck/SmallCheck properties, and any
    other types of tests into a single test suite.

category:             Testing
abi:                  462e921b0b6a9bf430b014c3cdb959ce
exposed:              True
exposed-modules:
    Test.Tasty Test.Tasty.Ingredients Test.Tasty.Ingredients.Basic
    Test.Tasty.Ingredients.ConsoleReporter Test.Tasty.Options
    Test.Tasty.Patterns.Eval Test.Tasty.Patterns.Parser
    Test.Tasty.Patterns.Printer Test.Tasty.Patterns.Types
    Test.Tasty.Providers Test.Tasty.Providers.ConsoleFormat
    Test.Tasty.Runners

hidden-modules:
    Control.Concurrent.Async Test.Tasty.Parallel Test.Tasty.Core
    Test.Tasty.Options.Core Test.Tasty.Options.Env Test.Tasty.Patterns
    Test.Tasty.Patterns.Expr Test.Tasty.Run Test.Tasty.Runners.Reducers
    Test.Tasty.Runners.Utils Test.Tasty.CmdLine
    Test.Tasty.Ingredients.ListTests
    Test.Tasty.Ingredients.IncludingOptions

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tasty-1.4.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tasty-1.4.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tasty-1.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tasty
hs-libraries:         HStasty-1.4.3-HawtMXzm4DS8dcW1CZQcKE
depends:
    ansi-terminal-1.0.2-8ftyjG1asvZBfIAqqefv8L base-4.17.2.1
    containers-0.6.7
    optparse-applicative-0.18.1.0-8BM84nMNO6C3REk9JaN2lH stm-2.5.1.0
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C transformers-0.5.6.2 unix-2.7.3

haddock-interfaces:   /usr/share/doc/haskell-tasty/html/tasty.haddock
haddock-html:         /usr/share/doc/haskell-tasty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

