#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tar
version:              0.5.1.1
visibility:           public
id:                   tar-0.5.1.1-BOkEX9vD5nGKWWsdaIwajq
key:                  tar-0.5.1.1-BOkEX9vD5nGKWWsdaIwajq
license:              BSD-3-Clause
copyright:
    2007 Bjorn Bringert <bjorn@bringert.net>
    2008-2016 Duncan Coutts <duncan@community.haskell.org>

maintainer:           Duncan Coutts <duncan@community.haskell.org>
author:
    Duncan Coutts <duncan@community.haskell.org>
    Bjorn Bringert <bjorn@bringert.net>

synopsis:             Reading, writing and manipulating ".tar" archive files.
description:
    This library is for working with \"@.tar@\" archive files. It
    can read and write a range of common variations of archive
    format including V7, POSIX USTAR and GNU formats.

    It provides support for packing and unpacking portable
    archives. This makes it suitable for distribution but not
    backup because details like file ownership and exact
    permissions are not preserved.

    It also provides features for random access to archive
    content using an index.

category:             Codec
abi:                  44fc99ac9739761b8024ccc591cb50f8
exposed:              True
exposed-modules:
    Codec.Archive.Tar Codec.Archive.Tar.Check Codec.Archive.Tar.Entry
    Codec.Archive.Tar.Index

hidden-modules:
    Codec.Archive.Tar.Types Codec.Archive.Tar.Read
    Codec.Archive.Tar.Write Codec.Archive.Tar.Pack
    Codec.Archive.Tar.Unpack Codec.Archive.Tar.Index.StringTable
    Codec.Archive.Tar.Index.IntTrie

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tar-0.5.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tar-0.5.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tar-0.5.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tar
hs-libraries:         HStar-0.5.1.1-BOkEX9vD5nGKWWsdaIwajq
depends:
    array-0.5.4.0 base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2 time-1.12.2

haddock-interfaces:   /usr/share/doc/haskell-tar/html/tar.haddock
haddock-html:         /usr/share/doc/haskell-tar/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

