#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-utils
version:              1.10.0
visibility:           public
id:                   tamarin-prover-utils-1.10.0-L96CeQmoFhO80758Bej0oi
key:                  tamarin-prover-utils-1.10.0-L96CeQmoFhO80758Bej0oi
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  950d9028b78a9e6bd325de540976f80b
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.EnvTracer Debug.Trace.Ignore Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.10.0-L96CeQmoFhO80758Bej0oi
depends:
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl base-4.17.2.1
    base64-bytestring-1.2.1.0-7Hc8HHLesUeC50K0z9QlBv binary-0.8.9.1
    blaze-builder-0.4.3-JltW0fO3TtKLaSjwHhTeiS bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0 dlist-1.0-3IsW2ghxYJNLBlqCManDLX
    exceptions-0.10.5 fclabels-2.0.5.1-1q3U54LmmAWGY2DT0KXJoF
    graphviz-2999.20.2.1-CqekttpgZjjIkFDbuMvZR2
    list-t-1.0.5.6-LBIRWY9Oam02zXEnY6OYeO mtl-2.2.2 pretty-1.1.3.6
    safe-0.3.21-60nVbSvEeiB1LI9CXyKW1J
    split-0.2.5-JeJxVdKJRKMda8iubaxqh
    syb-0.7.2.4-7rM6H2Cx7RdIPDVFkspy8A text-2.0.2 time-1.12.2
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

