#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-utils
version:              1.10.0
visibility:           public
id:                   tamarin-prover-utils-1.10.0-CspT5OIgmRXBvj6zKZ4IIG
key:                  tamarin-prover-utils-1.10.0-CspT5OIgmRXBvj6zKZ4IIG
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  b0d8d8086f6db11e2559eea6b60692f5
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.EnvTracer Debug.Trace.Ignore Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tamarin-prover-utils-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.10.0-CspT5OIgmRXBvj6zKZ4IIG
depends:
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl base-4.17.2.1
    base64-bytestring-1.2.1.0-H7PD9x3a1R75H5UmP3m5CT binary-0.8.9.1
    blaze-builder-0.4.4.1-Cau0yAlxVeRBhqZO9aptGP bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0 dlist-1.0-E99MqJW5mmB4kr4PCgIESI
    exceptions-0.10.5 fclabels-2.0.5.1-KPq2JgmNq7i4HJU2KCSghQ
    graphviz-2999.20.2.1-40Y7JoY5qPQJwN9rqbVW9P
    list-t-1.0.5.7-GiyCsWRvIJnKJGy8VJpPo5 mtl-2.2.2 pretty-1.1.3.6
    safe-0.3.21-ByjvVtJLwt5KrRntZowDKh
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-JxKwJKAj8VO69Skm5xz2vL
    text-2.0.2 time-1.12.2 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

