#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-theory
version:              1.10.0
visibility:           public
id:                   tamarin-prover-theory-1.10.0-JmXgUxoY1zC6TVVBN0LKpQ
key:                  tamarin-prover-theory-1.10.0-JmXgUxoY1zC6TVVBN0LKpQ
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>
    Cas Cremers <cremers@cispa.de>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Security protocol types and constraint solver library for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides the types to represent security
    protocols, and it implements the constraint solver.

category:             Theorem Provers
abi:                  5daac8afb71c0973daf210ba5a2a706a
exposed:              True
exposed-modules:
    ClosedTheory Items.AccLemmaItem Items.CaseTestItem Items.ExportInfo
    Items.LemmaItem Items.OpenTheoryItem Items.OptionItem
    Items.ProcessItem Items.RuleItem Items.TheoryItem Lemma OpenTheory
    Pretty Prover Rule Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.AnnotatedGoals
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot
    Theory.Constraint.System.Graph.Abbreviation
    Theory.Constraint.System.Graph.Graph
    Theory.Constraint.System.Graph.GraphRepr
    Theory.Constraint.System.Graph.Simplification
    Theory.Constraint.System.Guarded Theory.Constraint.System.JSON
    Theory.Model Theory.Model.Atom Theory.Model.Fact
    Theory.Model.Formula Theory.Model.Restriction Theory.Model.Rule
    Theory.Model.Signature Theory.Module Theory.Proof
    Theory.ProofSkeleton Theory.Sapic Theory.Sapic.Annotation
    Theory.Sapic.Pattern Theory.Sapic.Position Theory.Sapic.Print
    Theory.Sapic.Process Theory.Sapic.Term Theory.Text.Parser
    Theory.Text.Parser.Macro Theory.Text.Parser.Restriction
    Theory.Text.Parser.Signature Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.MessageDerivationChecks Theory.Tools.RuleVariants
    Theory.Tools.SubtermStore Theory.Tools.Wellformedness TheoryObject

hidden-modules:
    Theory.Syntactic.Predicate Theory.Text.Parser.Accountability
    Theory.Text.Parser.Exceptions Theory.Text.Parser.Fact
    Theory.Text.Parser.Formula Theory.Text.Parser.Lemma
    Theory.Text.Parser.Let Theory.Text.Parser.Proof
    Theory.Text.Parser.Rule Theory.Text.Parser.Sapic
    Theory.Text.Parser.Tactics Theory.Text.Parser.Term
    Theory.Sapic.PlainProcess Theory.Sapic.Substitution

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tamarin-prover-theory-1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tamarin-prover-theory-1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tamarin-prover-theory-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-theory
hs-libraries:         HStamarin-prover-theory-1.10.0-JmXgUxoY1zC6TVVBN0LKpQ
depends:
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    aeson-pretty-0.8.10-HWmn7v7pElT331cgWAs6cN array-0.5.4.0
    attoparsec-0.14.4-AS2Ju05FAjs55rPAuL3miO base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    directory-1.3.7.1 dlist-1.0-BKgPi70fx5AJreCYiKxIIN
    exceptions-0.10.5 fclabels-2.0.5.1-8OfdBD1rTW84uQEUFjRrWY
    filepath-1.4.2.2 mtl-2.2.2 parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    regex-pcre-0.95.0.1-5zy7zZE7dd8AnYSlLeRWMw
    regex-posix-0.96.0.2-AHNuIP1Pa8gKU2TxlSaYg9
    safe-0.3.21-4A1yMugax9JCQWzW2mE78Z
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tamarin-prover-term-1.10.0-FwydKVXQCGrE0sIDN90Ddz
    tamarin-prover-utils-1.10.0-KnNzj2bXxoz7G7dbjmUVuA text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-98fOhlqW0XqJefmRDJ9Z2w

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

