#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-theory
version:              1.10.0
visibility:           public
id:                   tamarin-prover-theory-1.10.0-C1pikW4dDa1EEzzp2aX7dV
key:                  tamarin-prover-theory-1.10.0-C1pikW4dDa1EEzzp2aX7dV
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>
    Cas Cremers <cremers@cispa.de>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Security protocol types and constraint solver library for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides the types to represent security
    protocols, and it implements the constraint solver.

category:             Theorem Provers
abi:                  8acc53fb5656dfda031023afa277ede5
exposed:              True
exposed-modules:
    ClosedTheory Items.AccLemmaItem Items.CaseTestItem Items.ExportInfo
    Items.LemmaItem Items.OpenTheoryItem Items.OptionItem
    Items.ProcessItem Items.RuleItem Items.TheoryItem Lemma OpenTheory
    Pretty Prover Rule Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.AnnotatedGoals
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot
    Theory.Constraint.System.Graph.Abbreviation
    Theory.Constraint.System.Graph.Graph
    Theory.Constraint.System.Graph.GraphRepr
    Theory.Constraint.System.Graph.Simplification
    Theory.Constraint.System.Guarded Theory.Constraint.System.JSON
    Theory.Model Theory.Model.Atom Theory.Model.Fact
    Theory.Model.Formula Theory.Model.Restriction Theory.Model.Rule
    Theory.Model.Signature Theory.Module Theory.Proof
    Theory.ProofSkeleton Theory.Sapic Theory.Sapic.Annotation
    Theory.Sapic.Pattern Theory.Sapic.Position Theory.Sapic.Print
    Theory.Sapic.Process Theory.Sapic.Term Theory.Text.Parser
    Theory.Text.Parser.Macro Theory.Text.Parser.Restriction
    Theory.Text.Parser.Signature Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.MessageDerivationChecks Theory.Tools.RuleVariants
    Theory.Tools.SubtermStore Theory.Tools.Wellformedness TheoryObject

hidden-modules:
    Theory.Syntactic.Predicate Theory.Text.Parser.Accountability
    Theory.Text.Parser.Exceptions Theory.Text.Parser.Fact
    Theory.Text.Parser.Formula Theory.Text.Parser.Lemma
    Theory.Text.Parser.Let Theory.Text.Parser.Proof
    Theory.Text.Parser.Rule Theory.Text.Parser.Sapic
    Theory.Text.Parser.Tactics Theory.Text.Parser.Term
    Theory.Sapic.PlainProcess Theory.Sapic.Substitution

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tamarin-prover-theory-1.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tamarin-prover-theory-1.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tamarin-prover-theory-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-theory
hs-libraries:         HStamarin-prover-theory-1.10.0-C1pikW4dDa1EEzzp2aX7dV
depends:
    aeson-2.1.2.1-1NeIvw5bSkQ9apxHmCtPBl
    aeson-pretty-0.8.10-2tNFY07YMRPWyoSCQYVlF array-0.5.4.0
    attoparsec-0.14.4-H6DCtC2rXm7CWC54FRqEZL base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    directory-1.3.7.1 dlist-1.0-E99MqJW5mmB4kr4PCgIESI
    exceptions-0.10.5 fclabels-2.0.5.1-3SMp9qGPU6IFaQ8ERA4OLn
    filepath-1.4.2.2 mtl-2.2.2 parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    regex-pcre-0.95.0.1-5zy7zZE7dd8AnYSlLeRWMw
    regex-posix-0.96.0.2-AHNuIP1Pa8gKU2TxlSaYg9
    safe-0.3.21-3kF9VX2rOl78iX2OdZTXNo
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tamarin-prover-term-1.10.0-2ovm5IofS7l2FbQB4Rf7py
    tamarin-prover-utils-1.10.0-JxbjvCRYzKf7w42VvskXZN text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-CJ0oCvoijnU13momfUMYNw

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

