#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-accountability
version:              1.10.0
visibility:           public
id:                   tamarin-prover-accountability-1.10.0-IWv9p228ovV1SujzAUoK3A
key:                  tamarin-prover-accountability-1.10.0-IWv9p228ovV1SujzAUoK3A
license:              LicenseRef-GPL
copyright:            (c) 2019-2021 Robert Künnemann, Kevin Morio & Yavor Ivanov
maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Kevin Morio <kevin.morio@cispa.de>,
    Yavor Ivanov <yavor.ivanov@cispa.de>

homepage:             https://tamarin-prover.github.io/
synopsis:             Library for accountability for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides support for accountability verification.

category:             Theorem Provers
abi:                  8abadc31a441b50f806ec2591224f5b1
exposed:              True
exposed-modules:      Accountability Accountability.Generation
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-accountability
hs-libraries:
    HStamarin-prover-accountability-1.10.0-IWv9p228ovV1SujzAUoK3A

depends:
    aeson-2.1.2.1-HPwo2VO3hzcFr4fiGB5Oro
    aeson-pretty-0.8.10-6mqlJbaGBfr9VazENxXqaY base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-3IsW2ghxYJNLBlqCManDLX exceptions-0.10.5
    fclabels-2.0.5.1-9ccC4tLhYke3RU0N4MU7bm mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-JL95sKpGk6lDCjB5kfGK6m
    safe-0.3.21-A7lw0NQn6dP12vgshNzPEt
    tamarin-prover-term-1.10.0-2wAyzHkSRGbKIxAWM3sLkh
    tamarin-prover-theory-1.10.0-OXYg6VGbc7FauVjr02Ek9
    tamarin-prover-utils-1.10.0-I62Rg08FMHg1Vg0OA60Eyo text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-36zMgJOhQUCURGVaG3Hi9

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-accountability/html/tamarin-prover-accountability.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-accountability/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

