#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-accountability
version:              1.10.0
visibility:           public
id:                   tamarin-prover-accountability-1.10.0-IM8Xiz4tb1d9xnMFLGXilz
key:                  tamarin-prover-accountability-1.10.0-IM8Xiz4tb1d9xnMFLGXilz
license:              LicenseRef-GPL
copyright:            (c) 2019-2021 Robert Künnemann, Kevin Morio & Yavor Ivanov
maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Kevin Morio <kevin.morio@cispa.de>,
    Yavor Ivanov <yavor.ivanov@cispa.de>

homepage:             https://tamarin-prover.github.io/
synopsis:             Library for accountability for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides support for accountability verification.

category:             Theorem Provers
abi:                  eaea51a9afccf37c7e57df2e483e2447
exposed:              True
exposed-modules:      Accountability Accountability.Generation
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-accountability
hs-libraries:
    HStamarin-prover-accountability-1.10.0-IM8Xiz4tb1d9xnMFLGXilz

depends:
    aeson-2.1.2.1-5gViDrHjeNhDfT19MwgeMT
    aeson-pretty-0.8.10-B9vRt54sIQsFdBteW4H6Dw base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-3IsW2ghxYJNLBlqCManDLX exceptions-0.10.5
    fclabels-2.0.5.1-4KFRusoOSMd45aSJieZgl1 mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-JGR6CJrZQIk4XMfGgAscmU
    safe-0.3.21-5rcOjzCJ9nx5zsTE32vvEc
    tamarin-prover-term-1.10.0-Adm2O5zXoscABsBNXC7OT7
    tamarin-prover-theory-1.10.0-H37w4dlPGln3Y6im6wERFa
    tamarin-prover-utils-1.10.0-Cp6BJIuaBctBrKbsz4ZlZ2 text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-K11Ic13eIeQ7Lzq0J8rpY6

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-accountability/html/tamarin-prover-accountability.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-accountability/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

