#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-accountability
version:              1.10.0
visibility:           public
id:                   tamarin-prover-accountability-1.10.0-GdTH4gKllCQEtJT50dAcNP
key:                  tamarin-prover-accountability-1.10.0-GdTH4gKllCQEtJT50dAcNP
license:              LicenseRef-GPL
copyright:            (c) 2019-2021 Robert Künnemann, Kevin Morio & Yavor Ivanov
maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Kevin Morio <kevin.morio@cispa.de>,
    Yavor Ivanov <yavor.ivanov@cispa.de>

homepage:             https://tamarin-prover.github.io/
synopsis:             Library for accountability for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides support for accountability verification.

category:             Theorem Provers
abi:                  5883caa19e960dd14f169f1fcb6f8efd
exposed:              True
exposed-modules:      Accountability Accountability.Generation
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-accountability
hs-libraries:
    HStamarin-prover-accountability-1.10.0-GdTH4gKllCQEtJT50dAcNP

depends:
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm
    aeson-pretty-0.8.10-BWBr3n5fp9E4XyIlTfMbVH base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    fclabels-2.0.5.1-8JtpLL3qoGWC3JMA2kvRv4 mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-5UoKzxGMQtT2yxknZlOMkE
    safe-0.3.21-Esyyru5CUzTFDSdkcA7Wuj
    tamarin-prover-term-1.10.0-IEwVMGzyxuy5s5jC6Kcg0n
    tamarin-prover-theory-1.10.0-Ep9bQoL5QLM91nFJUwJEFa
    tamarin-prover-utils-1.10.0-2SJQ2uW0vuP59FUeaLrdsW text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-6SbQTkGosLW2XGmqWEqtWi

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-accountability/html/tamarin-prover-accountability.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-accountability/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

