#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-accountability
version:              1.10.0
visibility:           public
id:                   tamarin-prover-accountability-1.10.0-GytOplUehm6JdhP91SpvJO
key:                  tamarin-prover-accountability-1.10.0-GytOplUehm6JdhP91SpvJO
license:              LicenseRef-GPL
copyright:            (c) 2019-2021 Robert Künnemann, Kevin Morio & Yavor Ivanov
maintainer:           Robert Künnemann <robert@kunnemann.de>
author:
    Robert Künnemann <robert@kunnemann.de>,
    Kevin Morio <kevin.morio@cispa.de>,
    Yavor Ivanov <yavor.ivanov@cispa.de>

homepage:             https://tamarin-prover.github.io/
synopsis:             Library for accountability for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides support for accountability verification.

category:             Theorem Provers
abi:                  6db5bb683145f5c58ef9f8dc8f9377b9
exposed:              True
exposed-modules:      Accountability Accountability.Generation
import-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/tamarin-prover-accountability-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-accountability
hs-libraries:
    HStamarin-prover-accountability-1.10.0-GytOplUehm6JdhP91SpvJO

depends:
    aeson-2.1.2.1-7VTFzNaeQhH4xougawMBap
    aeson-pretty-0.8.10-rURyXjN4BvGGSaNmtsiAe base-4.17.2.1
    binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    fclabels-2.0.5.1-JyvAhp4Jmd34XI2I22nx7f mtl-2.2.2
    parallel-3.2.2.0-KJ5o3ImR3G8wdLWLqGjpy parsec-3.1.16.1
    process-1.6.18.0 raw-strings-qq-1.1-73kb7SizjX3bDDbE8dc5y
    safe-0.3.21-EvJ6Ca7ZgFx49PYHKYQDLu
    tamarin-prover-term-1.10.0-Bt5GDJGd4FW2BhnczQTrEh
    tamarin-prover-theory-1.10.0-5KnMzOjfk0R6ZpN7ueXsDQ
    tamarin-prover-utils-1.10.0-F0GurhxSudIIYztfFtbkWz text-2.0.2
    transformers-0.5.6.2 uniplate-1.6.13-ARpzrG9LR5aBo2wcAj7tIM

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-accountability/html/tamarin-prover-accountability.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-accountability/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

