#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 storable-tuple
version:              0.1
visibility:           public
id:                   storable-tuple-0.1-Fu1kbExf7Eo5Q71oBVApfC
key:                  storable-tuple-0.1-Fu1kbExf7Eo5Q71oBVApfC
license:              BSD-3-Clause
maintainer:           Henning Thielemann <storable@henning-thielemann.de>
author:               Henning Thielemann <storable@henning-thielemann.de>
stability:            Experimental
homepage:             http://code.haskell.org/~thielema/storable-tuple/
synopsis:             Storable instance for pairs and triples
description:
    Provides a Storable instance for pair and triple
    which should be binary compatible with C99 and C++.
    The only purpose of this package is to provide a standard location
    for this instance so that other packages needing this instance
    can play nicely together.
    Note however, that the original purpose of the @Storable@ class
    was the transfer of primitive types between Haskell and foreign code.
    This purpose was already extended by HSC,
    which creates @Storable@ instances for records from C header files.
    Nonetheless,
    @Storable@ instances for tuples were omitted from @base@ by intention.
    Instead of using the orphan instances from this package,
    you may instead use the custom class or the wrapper type
    from the module @Foreign.Storable.Record.Tuple@
    from the package @storable-record@.

category:             Data, Foreign
abi:                  d3d4a8f713f08b9862abf1e41b36ad0a
exposed:              True
exposed-modules:      Foreign.Storable.Tuple
import-dirs:          /usr/lib/ghc-9.4.8/site-local/storable-tuple-0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/storable-tuple-0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/storable-tuple-0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-storable-tuple
hs-libraries:         HSstorable-tuple-0.1-Fu1kbExf7Eo5Q71oBVApfC
depends:
    base-4.17.2.1 base-orphans-0.9.3-E4zHJcDxgJnKs72QOKOW61
    storable-record-0.0.7-KaY6284ZTMw5lEgrhWjoTP
    utility-ht-0.0.17.2-2a5YKAXf2uu2lBH7gdZ2n0

haddock-interfaces:
    /usr/share/doc/haskell-storable-tuple/html/storable-tuple.haddock

haddock-html:         /usr/share/doc/haskell-storable-tuple/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

