#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 storable-record
version:              0.0.7
visibility:           public
id:                   storable-record-0.0.7-KaY6284ZTMw5lEgrhWjoTP
key:                  storable-record-0.0.7-KaY6284ZTMw5lEgrhWjoTP
license:              BSD-3-Clause
maintainer:           Henning Thielemann <storable@henning-thielemann.de>
author:               Henning Thielemann <storable@henning-thielemann.de>
stability:            Experimental
homepage:             http://code.haskell.org/~thielema/storable-record/
synopsis:             Elegant definition of Storable instances for records
description:
    With this package
    you can build a Storable instance of a record type
    from Storable instances of its elements in an elegant way.
    It does not do any magic,
    just a bit arithmetic to compute the right offsets,
    that would be otherwise done manually
    or by a preprocessor like C2HS.
    I cannot promise that the generated memory layout
    is compatible with that of a corresponding C struct.
    However, the module generates the smallest layout
    that is possible with respect to the alignment of the record elements.
    If you encounter, that a record does not have a compatible layout,
    we should fix that.
    But also without C compatibility this package is useful
    e.g. in connection with StorableVector.

    We provide Storable instance support for several cases:

    * If you wrap a type in a @newtype@,
    then you can lift its '\''Storable'\'' instance to that @newtype@
    with the module "Foreign.Storable.Newtype".
    This way you do not need the @GeneralizedNewtypeDeriving@ feature of GHC.

    * If you have a type that is an instance of '\''Traversable'\'',
    you can use that feature for implementation of '\''Storable'\'' methods.
    The module "Foreign.Storable.Traversable"
    allows manipulation of the portion of your type,
    that is accessible by '\''Traversable'\'' methods.
    For instance with the type
    @data T a = Cons Int [a]@
    and an according '\''Traversable'\'' implementation,
    you can load and store the elements of the contained list.
    This may be part of a '\''Storable'\'' implementation of the whole type.

    * If you have a record containing elements of various types,
    then you need module "Foreign.Storable.Record".

    Note however that the Storable instances
    defined with this package are quite slow in (up to) GHC-6.12.1.
    I'\''m afraid this is due to incomplete inlining,
    but we have still to investigate the problem.

    For examples see packages @storable-tuple@ and @sample-frame@.

category:             Data, Foreign
abi:                  2e699bb17e731f533d4c2dbb8cc20bc4
exposed:              True
exposed-modules:
    Foreign.Storable.FixedArray Foreign.Storable.Newtype
    Foreign.Storable.Record Foreign.Storable.Record.Tuple
    Foreign.Storable.Traversable

hidden-modules:
    Foreign.Storable.RecordMinimalSize Foreign.Storable.RecordReaderPtr
    Foreign.Storable.TraversableUnequalSizes

import-dirs:          /usr/lib/ghc-9.4.8/site-local/storable-record-0.0.7
library-dirs:         /usr/lib/ghc-9.4.8/site-local/storable-record-0.0.7
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/storable-record-0.0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-storable-record
hs-libraries:         HSstorable-record-0.0.7-KaY6284ZTMw5lEgrhWjoTP
depends:
    QuickCheck-2.14.3-CpTyyGCQ8vELJYAkeHIgu4 base-4.17.2.1
    transformers-0.5.6.2 utility-ht-0.0.17.2-2a5YKAXf2uu2lBH7gdZ2n0

haddock-interfaces:
    /usr/share/doc/haskell-storable-record/html/storable-record.haddock

haddock-html:         /usr/share/doc/haskell-storable-record/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

