#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 stm-containers
version:              1.2.1.1
visibility:           public
id:                   stm-containers-1.2.1.1-2yrmWgRewx0SYHCQPWX8f
key:                  stm-containers-1.2.1.1-2yrmWgRewx0SYHCQPWX8f
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/stm-containers
synopsis:             Containers for STM
description:
    This library is based on an STM-specialized implementation of
    Hash Array Mapped Trie.
    It provides efficient implementations of @Map@, @Set@
    and other data structures,
    which starting from version @1@ perform even better than their counterparts from \"unordered-containers\",
    but also scale well on concurrent access patterns.
    .
    For details on performance of the library, which are a bit outdated, see
    <http://nikita-volkov.github.io/stm-containers/ this blog post>.

category:             Data Structures, STM, Concurrency
abi:                  489829adee111babd889e68f45a2e96a
exposed:              True
exposed-modules:
    StmContainers.Bimap StmContainers.Map StmContainers.Multimap
    StmContainers.Set

hidden-modules:       StmContainers.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/stm-containers-1.2.1.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/stm-containers-1.2.1.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/stm-containers-1.2.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-stm-containers
hs-libraries:         HSstm-containers-1.2.1.1-2yrmWgRewx0SYHCQPWX8f
depends:
    base-4.17.2.1 deferred-folds-0.9.18.7-Ew5gyJDfcgY76uWEKNzk3P
    focus-1.0.3.2-E3Blu9EZELRHVhmXdJrXzM
    hashable-1.4.4.0-E3AlBtIk95ULiiCgr6U6fg
    list-t-1.0.5.7-DVWn5w7VputIjiu3vTqfip
    stm-hamt-1.2.1.1-5ONbawlpjSkGwh561npVuq transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-stm-containers/html/stm-containers.haddock

haddock-html:         /usr/share/doc/haskell-stm-containers/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

