#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-AXrJQs5jYvZAMa8KtLWBiO
key:                  snap-core-1.0.5.1-AXrJQs5jYvZAMa8KtLWBiO
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  f54f362e497b37c3d47a024a11f6537f
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-AXrJQs5jYvZAMa8KtLWBiO
depends:
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    attoparsec-0.14.4-G1kY79wp4BCwb0EQHIFQA base-4.17.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-IP68CV0DvpE446u5n94xId
    containers-0.6.7 directory-1.3.7.1 filepath-1.4.2.2
    hashable-1.4.4.0-L4Cy5OzOiFo7EDda82f1f2
    io-streams-1.5.2.2-CpCUK3rfMgu8tBf2kvm9bO
    lifted-base-0.2.3.12-92dtMXnp5yseTGQzMSimv
    monad-control-1.0.3.1-6r6BSlUHMqe6Z3rapESv5L mtl-2.2.2
    network-3.1.4.0-480JOeNLV9o5fbqpzcHJCB
    network-uri-2.6.4.2-DCTjueINivX2RvibFUmCb5
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    random-1.2.1.3-2jtdg0FBSKzAasSf5KWDPe
    readable-0.3.1-IDsQMpnz7oHK9VbHbSIfA7
    regex-posix-0.96.0.2-AHNuIP1Pa8gKU2TxlSaYg9 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 transformers-base-0.4.6-CfAkwLteicbGbY5LSBi8gU
    unix-compat-0.7.4.1-HfukfXMXV6LHwjUE321L3t
    unordered-containers-0.2.20-6WajAJaPEOH3f3auRxdjt7
    vector-0.13.2.0-ESntcdl2teUG0zU6GNugJH

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

