#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-2HYZwroTF1H7DPpv1tNyVG
key:                  snap-core-1.0.5.1-2HYZwroTF1H7DPpv1tNyVG
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  89367afd365970f4613f66ed3bb8e5e3
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-2HYZwroTF1H7DPpv1tNyVG
depends:
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    attoparsec-0.14.4-2WnTlN46elo3llwbGCF7aS base-4.17.2.1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-KZI0Gb9gPGwAGX5pgA0Afl
    containers-0.6.7 directory-1.3.7.1 filepath-1.4.2.2
    hashable-1.4.4.0-Bi9h4Si3Ui62sqHmMmGfiv
    io-streams-1.5.2.2-6YjEgvZ8IEtKUYYEzkkSw6
    lifted-base-0.2.3.12-LST055rnE0VCjnKmrxKBTf
    monad-control-1.0.3.1-KCPiw1D9LlID1g5tbWXft mtl-2.2.2
    network-3.1.4.0-ASj1hBk5tU17JSnFMFmeWy
    network-uri-2.6.4.2-4a4fvaL8hlS8iUTVwHnYtf
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    random-1.2.1.3-KpUTlSxpYoQ2cUlPZmFoDo
    readable-0.3.1-IDsQMpnz7oHK9VbHbSIfA7
    regex-posix-0.96.0.2-AHNuIP1Pa8gKU2TxlSaYg9 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 transformers-base-0.4.6-ChRW239HasyDHet7IIm2Fi
    unix-compat-0.7.4-L2kjPBf5fIp84KOh8GLDxJ
    unordered-containers-0.2.20-3czZ5Len2GTFaAkRxFZe7E
    vector-0.13.2.0-GTax7SJDHXyLP8P6Lzhygl

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

