#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-FBZgzkwEree9k8dcF68ra7
key:                  servant-swagger-1.2.1-FBZgzkwEree9k8dcF68ra7
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  d76fa8e7e3631e78923578e6f1bebaf7
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-FBZgzkwEree9k8dcF68ra7
depends:
    QuickCheck-2.15.0.1-6OtfWMF4tzoHoYkQbgugv4
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT
    aeson-pretty-0.8.10-Eh8NnpcmY9CGqm5LnFuS6D base-4.17.2.1
    base-compat-0.14.1-EDnSvJBeGTDBBfh2KFPKKz bytestring-0.11.5.3
    hspec-2.11.3-34tKFAZ1BmRHyTkuI4VE9k
    http-media-0.8.1.1-3yg4hd8oTIw74CJ0L6C5aK
    insert-ordered-containers-0.2.5.3-GhRoCGkSv6S83TE0sczSkv
    lens-5.3.3-26VlyqkFVMA2DXZQVmsUyD
    servant-0.20.3.0-6SlfiHuBEfxC2AAEX8egY9
    singleton-bool-0.1.8-HNTwsUSLQUoJc2X6gFoNSF
    swagger2-2.8.10-9P4fjWMC2DdJxWFglyXMGl text-2.0.2
    unordered-containers-0.2.20.1-98Hg6PuNW0XDqLHXL1727Z

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

