#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-4NBW46hsChRKZTf7a0yVzm
key:                  servant-swagger-1.2.1-4NBW46hsChRKZTf7a0yVzm
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  78e038e8c022503e3659d067fd2983d2
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-4NBW46hsChRKZTf7a0yVzm
depends:
    QuickCheck-2.15.0.1-KEw9aoMxM6q6i8cfYYug2V
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    aeson-pretty-0.8.10-7LLoAxhJYrxHVdlJthoYBc base-4.17.2.1
    base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA bytestring-0.11.5.3
    hspec-2.11.1-GIH8vH53bMNE8dUYSTqrgH
    http-media-0.8.1.1-Jnf81DzN7R06o05XXV2prV
    insert-ordered-containers-0.2.5.3-aV927UxxNKGkIQ6PVKesc
    lens-5.3.1-FP95Rv35No71PYJue58Hxp
    servant-0.20.3.0-6aPw6lNINrm2ettSeO4tR4
    singleton-bool-0.1.8-36Sm5MvPY4mKWcF4XT2GeX
    swagger2-2.8.10-BxwgNKVS7e3CnCdyI3YQIQ text-2.0.2
    unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

