#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3.1
visibility:           public
id:                   semialign-1.3.1-LADOE4Hp3LXBhP5tZPt1XG
key:                  semialign-1.3.1-LADOE4Hp3LXBhP5tZPt1XG
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  9a294110ac275fe63a1434b666841b66
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3.1-LADOE4Hp3LXBhP5tZPt1XG
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.7.0-GgneweRn8eTKcMM4X3n956
    indexed-traversable-0.1.4-7gBVHmZFzpQ83JoiKc0FfD
    indexed-traversable-instances-0.1.2-8VEy9BHeErIJdI5GQlmOtj
    semigroupoids-6.0.1-KCG1rdxHmnQC2yfRp1443g
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2.1-8SYvDH688DfqbUZb9lXXl transformers-0.5.6.2
    unordered-containers-0.2.20-2N1fR83O3bC5qS2nrjaL2B
    vector-0.13.2.0-EQFZws9ZIK8A2ESM3MR23n

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

