#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3.1
visibility:           public
id:                   semialign-1.3.1-DfGCFtet26l102Bwpbsfor
key:                  semialign-1.3.1-DfGCFtet26l102Bwpbsfor
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  ddda8fef1127058f6211d6aaba1614c2
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3.1-DfGCFtet26l102Bwpbsfor
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.5.0-EMf4Iv4OllUGRj72K4SCf0
    indexed-traversable-0.1.4-HEP7TGiK1hWFsWJfrW3hPw
    indexed-traversable-instances-0.1.2-KE7nic98XBTKtWsaj3A3RT
    semigroupoids-6.0.1-Aj0i7ZgNxib61OGk1aNVLj
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2.1-I9iY860Hclw5NMJO4VvoCM transformers-0.5.6.2
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    vector-0.13.2.0-B3Rnif6nhJNLHPAZlzHp2g

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

