#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3.1
visibility:           public
id:                   semialign-1.3.1-AAvJVPVdO8TBL7MKKJqZb1
key:                  semialign-1.3.1-AAvJVPVdO8TBL7MKKJqZb1
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  4e346af4dc0f0323a65b214a0f588526
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3.1-AAvJVPVdO8TBL7MKKJqZb1
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.4.0-BPBogvz51gTFqjBeDWtSVb
    indexed-traversable-0.1.4-1dhHBoLFntW5SGzstHUOxj
    indexed-traversable-instances-0.1.2-5TA2sj66Sam6HKHZ8cM1ta
    semigroupoids-6.0.1-9Wq7OVzTmCiAXe4kmGdK06
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2.1-3qxTTL6t99CKTPsdFvTt2J transformers-0.5.6.2
    unordered-containers-0.2.20-7dvM9aaOf5JATet72j0BPX
    vector-0.13.2.0-JDMr93x2QgFDQPvksTJZzq

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

