#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 semialign
version:              1.3
visibility:           public
id:                   semialign-1.3-7jhSqYXIKzDKDUP5Ogp6as
key:                  semialign-1.3-7jhSqYXIKzDKDUP5Ogp6as
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  5da488a259c0850f6c2686c21dc108d4
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/semialign-1.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/semialign-1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.3-7jhSqYXIKzDKDUP5Ogp6as
depends:
    base-4.17.2.1 containers-0.6.7
    hashable-1.4.4.0-C1fFIG7AZLC7j0jzLm97Uw
    indexed-traversable-0.1.4-2T176InstcMqAaY6WCojl
    indexed-traversable-instances-0.1.2-Dp41K1CJgQbA1l6gXnWHNf
    semigroupoids-6.0.1-FMYBJOyO4ro7UvayiHjr7b
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C
    these-1.2.1-8N2G6PeN9eQ6G2ecL7DSJd transformers-0.5.6.2
    unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    vector-0.13.2.0-GDtmlcfK9QZ7E5AlTQVnIi

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

