#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-90veyUP8URc7FJ2mxAwUTa
key:                  scotty-0.22-90veyUP8URc7FJ2mxAwUTa
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  2ee0c996743f1f24cec1490afefd6e1f
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-90veyUP8URc7FJ2mxAwUTa
depends:
    aeson-2.1.2.1-LvJWrHbVhNW5j5NGQeCpIT base-4.17.2.1
    blaze-builder-0.4.4.1-Fu0lIXvNfl2GZl8eSsy5LD bytestring-0.11.5.3
    case-insensitive-1.2.1.0-3W7hj1sdmUw2Fh1p1ue6cC
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi exceptions-0.10.5
    http-types-0.12.4-Lh5dVrkMNHmKdCH2kircer
    monad-control-1.0.3.1-Gznm0l8Lbkh1N6Qfynm2B4 mtl-2.2.2
    network-3.1.4.0-FZePtqluqyjFxAKIHdZ8Kd
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8
    resourcet-1.2.6-2BcDKwHjSabK2j2MMy69bs stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    transformers-base-0.4.6-9kDn83Yy5E7DotDycldsLa
    unliftio-0.2.25.1-GEnpBLbf1o3B67bTK8jYGM
    wai-3.2.4-FetgZkW1yF462S5B7261uz
    wai-extra-3.1.17-KKZMoiquzOn1YwjEb4PCwP
    warp-3.3.30-Dns0BUI9BD6AAY9Q0OBUfS

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

