#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-B9BTjgB6uStBXuhZvt3eHk
key:                  scotty-0.22-B9BTjgB6uStBXuhZvt3eHk
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  6a174191ee6ca8b37630f5e5dd35d672
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-B9BTjgB6uStBXuhZvt3eHk
depends:
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz base-4.17.2.1
    blaze-builder-0.4.4-LpfpwWComBBEX8xWeKu4OT bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4S8KsHm7tqa4BSXUqBqEFP
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw
    data-default-class-0.1.2.2-2EcHBs5cfSFLku8331ZnRi exceptions-0.10.5
    http-types-0.12.4-8AFNw5oQ8TE9V2A9rZjrTr
    monad-control-1.0.3.1-Cwvaec5wBZ2EEdW1WlpKbT mtl-2.2.2
    network-3.1.4.0-GjkG889aAvvIfieaCEFwUy
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8
    resourcet-1.2.6-AVTqnIhFfb1JoG6KRaDalG stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    transformers-base-0.4.6-F1VMXh3wf3eA4R3d16Dsbd
    unliftio-0.2.25.1-CGBfKXBtKnE4SxcBcMK6gV
    wai-3.2.4-7AO9d5JyralLoyfSO8kkij
    wai-extra-3.1.17-DxFwVatTeNLlcKV8bcmaH
    warp-3.3.30-SQgNLAClSCLXsKRoqZBVX

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

