#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-2QADwRpxh8Q7yVCIfbijDe
key:                  scotty-0.22-2QADwRpxh8Q7yVCIfbijDe
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  2f779a838721f780ab67939cc4150534
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-2QADwRpxh8Q7yVCIfbijDe
depends:
    aeson-2.1.2.1-HdmwuFbnNgF6PqutsUaf6Y base-4.17.2.1
    blaze-builder-0.4.3-KajDOuS86PHBEcDCbLATP7 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-Abd5Q51hq5G7EsMEex29Bt
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm
    data-default-class-0.1.2.0-J3yYo85AtrC9KKZSpt62Yc exceptions-0.10.5
    http-types-0.12.4-ERErpW4oIqaKIzWiLMLiFN
    monad-control-1.0.3.1-8AXUx5j0A3gJs5QISnlyLH mtl-2.2.2
    network-3.1.4.0-L93bqt4J89t6uDPHvRPUpA
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8
    resourcet-1.2.6-EDu2BuTIWaf4YhdsfzLxLM stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    transformers-base-0.4.6-78jU0JNUXtBLG8mJHUeCid
    unliftio-0.2.25.1-CSkQ6WBjw9j80OvsxjG0yH
    wai-3.2.4-4XAAckw9HTnIyst5cAezpH
    wai-extra-3.1.17-53XV29eB5n9H5kmds7FJvQ
    warp-3.3.30-1sM6lmV0MZX18rPjR7YNXZ

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

