#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scientific
version:              0.3.8.0
visibility:           public
id:                   scientific-0.3.8.0-BCRNugtxiDS8UMOiZ0ZEsF
key:                  scientific-0.3.8.0-BCRNugtxiDS8UMOiZ0ZEsF
license:              BSD-3-Clause
maintainer:           Bas van Dijk <v.dijk.bas@gmail.com>
author:               Bas van Dijk
homepage:             https://github.com/basvandijk/scientific
synopsis:             Numbers represented using scientific notation
description:
    "Data.Scientific" provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.

    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.

    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:

    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.

    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:

    >>> read "1e1000000000" :: Scientific
    1.0e1000000000

    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.

category:             Data
abi:                  fc8447d2f885991eef78f44ea02e691d
exposed:              True
exposed-modules:
    Data.ByteString.Builder.Scientific Data.Scientific
    Data.Text.Lazy.Builder.Scientific

hidden-modules:       GHC.Integer.Compat Utils
import-dirs:          /usr/lib/ghc-9.4.8/site-local/scientific-0.3.8.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/scientific-0.3.8.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/scientific-0.3.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scientific
hs-libraries:         HSscientific-0.3.8.0-BCRNugtxiDS8UMOiZ0ZEsF
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7
    deepseq-1.4.8.0 hashable-1.4.5.0-DrXzgEMDRcV8gNOMGO5wPZ
    integer-logarithms-1.0.4-4bWNdqIbs8cIP5hwmbN8Af
    primitive-0.9.1.0-Jxt7FQpUmq1Ffbc4VwJGN5 template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-scientific/html/scientific.haddock
haddock-html:         /usr/share/doc/haskell-scientific/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

