#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 retrie
version:              1.2.3
visibility:           public
id:                   retrie-1.2.3-KtKmfBE5qoA864F4kn2GVo
key:                  retrie-1.2.3-KtKmfBE5qoA864F4kn2GVo
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  ca7ee1466f2a8d5db2804fbba9f766df
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.Elaborate Retrie.ExactPrint Retrie.ExactPrint.Annotated
    Retrie.Expr Retrie.Fixity Retrie.FreeVars Retrie.GHC
    Retrie.GroundTerms Retrie.Monad Retrie.Options
    Retrie.PatternMap.Bag Retrie.PatternMap.Class
    Retrie.PatternMap.Instances Retrie.Pretty Retrie.Quantifiers
    Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Patterns
    Retrie.Rewrites.Rules Retrie.Rewrites.Types Retrie.Run Retrie.SYB
    Retrie.Subst Retrie.Substitution Retrie.Types Retrie.Universe
    Retrie.Util

import-dirs:          /usr/lib/ghc-9.6.6/site-local/retrie-1.2.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/retrie-1.2.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/retrie-1.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-retrie
hs-libraries:         HSretrie-1.2.3-KtKmfBE5qoA864F4kn2GVo
depends:
    ansi-terminal-1.0.2-BPjCUZulbk02l8COiFLYJh
    async-2.2.5-7rznh9Npau1HJJ6XeEC4Wn base-4.18.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.3-DC0AJbPUVLOH54ZbhVmf2Q directory-1.3.8.5
    filepath-1.4.300.1 ghc-9.6.6
    ghc-exactprint-1.7.1.0-35rFiwzPpiYEb7xuk53X9A
    list-t-1.0.5.7-H4gil8zIBDW3VbwrCHvXvj mtl-2.3.1
    optparse-applicative-0.18.1.0-GNgTM1Z51EJ46yTCRGWgwm
    process-1.6.19.0 random-shuffle-0.0.4-3tulNpTRIdfBNUcvDQSwIf
    syb-0.7.3-MvqtDDcT2PHyhdKWhEKAp text-2.0.2 transformers-0.6.1.0
    unordered-containers-0.2.20.1-LJBbYvuM7Af6ez80tefkUA

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

