#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 retrie
version:              1.2.3
visibility:           public
id:                   retrie-1.2.3-6QNQVA1yacv6MD9F4dUEWB
key:                  retrie-1.2.3-6QNQVA1yacv6MD9F4dUEWB
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  037f865ff98acef9ce778b594edd299e
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.Elaborate Retrie.ExactPrint Retrie.ExactPrint.Annotated
    Retrie.Expr Retrie.Fixity Retrie.FreeVars Retrie.GHC
    Retrie.GroundTerms Retrie.Monad Retrie.Options
    Retrie.PatternMap.Bag Retrie.PatternMap.Class
    Retrie.PatternMap.Instances Retrie.Pretty Retrie.Quantifiers
    Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Patterns
    Retrie.Rewrites.Rules Retrie.Rewrites.Types Retrie.Run Retrie.SYB
    Retrie.Subst Retrie.Substitution Retrie.Types Retrie.Universe
    Retrie.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-retrie
hs-libraries:         HSretrie-1.2.3-6QNQVA1yacv6MD9F4dUEWB
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    async-2.2.5-I3c3jWJAJDg4b98EnH7ZrW base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.2-95OdNmNpLKa9cNDp3ZlqO5 directory-1.3.7.1
    filepath-1.4.2.2 ghc-9.4.8
    ghc-exactprint-1.6.1-3pSMHK8C4BX5Li8EjkUWVY
    list-t-1.0.5.7-1gwEpyXil7V2fANpblLDrc mtl-2.2.2
    optparse-applicative-0.18.1.0-79DXPPhnqn915zrePmz04b
    process-1.6.18.0 random-shuffle-0.0.4-LcVTpVLvecmIsPVYz5N07W
    syb-0.7.3-GzxvBIT7N6LHXGQxqlBVFk text-2.0.2 transformers-0.5.6.2
    unordered-containers-0.2.20-FOY8P5Y3sqjANbVUEJi9Vi

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

