#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 retrie
version:              1.2.3
visibility:           public
id:                   retrie-1.2.3-GYbCXer6mqR94GJm51tHyH
key:                  retrie-1.2.3-GYbCXer6mqR94GJm51tHyH
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  3ce5a1115fe22d0bc76aceb56dad9300
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.Elaborate Retrie.ExactPrint Retrie.ExactPrint.Annotated
    Retrie.Expr Retrie.Fixity Retrie.FreeVars Retrie.GHC
    Retrie.GroundTerms Retrie.Monad Retrie.Options
    Retrie.PatternMap.Bag Retrie.PatternMap.Class
    Retrie.PatternMap.Instances Retrie.Pretty Retrie.Quantifiers
    Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Patterns
    Retrie.Rewrites.Rules Retrie.Rewrites.Types Retrie.Run Retrie.SYB
    Retrie.Subst Retrie.Substitution Retrie.Types Retrie.Universe
    Retrie.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-retrie
hs-libraries:         HSretrie-1.2.3-GYbCXer6mqR94GJm51tHyH
depends:
    ansi-terminal-1.0.2-FkjFmzyZyQ09kjMl1I4g29
    async-2.2.5-LqkzH7L8HyYHud0cQFVYjz base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy directory-1.3.7.1
    filepath-1.4.2.2 ghc-9.4.8
    ghc-exactprint-1.6.1-EcdZKTsecxy1za7YduG1kI
    list-t-1.0.5.7-4DAI5YQwQDQ8nQTHNFeVF7 mtl-2.2.2
    optparse-applicative-0.18.1.0-LtQWPLKmjlx59fIGxpWSti
    process-1.6.18.0 random-shuffle-0.0.4-3FgPUc60nhV2vVplfBIOu
    syb-0.7.3-DwsmCi1fmJmFd2VOkUYSQg text-2.0.2 transformers-0.5.6.2
    unordered-containers-0.2.20-7dvM9aaOf5JATet72j0BPX

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

