#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 recursion-schemes
version:              5.2.3
visibility:           public
id:                   recursion-schemes-5.2.3-5woeaId5C4B5ttDdJTLm7
key:                  recursion-schemes-5.2.3-5woeaId5C4B5ttDdJTLm7
license:              BSD-2-Clause
copyright:            Copyright (C) 2008-2015 Edward A. Kmett
maintainer:
    "Samuel Gélineau" <gelisam@gmail.com>,
    "Ryan Scott" <ryan.gl.scott@gmail.com>,
    "Luc Tielen" <luc.tielen@gmail.com>

author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/recursion-schemes/
synopsis:
    Representing common recursion patterns as higher-order functions

description:
    Many recursive functions share the same structure, e.g. pattern-match on the input and, depending on the data constructor, either recur on a smaller input or terminate the recursion with the base case. Another one: start with a seed value, use it to produce the first element of an infinite list, and recur on a modified seed in order to produce the rest of the list. Such a structure is called a recursion scheme. Using higher-order functions to implement those recursion schemes makes your code clearer, faster, and safer. See README for details.

category:             Control, Recursion
abi:                  bec8dc3f7d4c9c5c7bb06b353b3f450f
exposed:              True
exposed-modules:
    Data.Functor.Base Data.Functor.Foldable Data.Functor.Foldable.TH

hidden-modules:       Paths_recursion_schemes
import-dirs:          /usr/lib/ghc-9.4.8/site-local/recursion-schemes-5.2.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/recursion-schemes-5.2.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/recursion-schemes-5.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-recursion-schemes
hs-libraries:         HSrecursion-schemes-5.2.3-5woeaId5C4B5ttDdJTLm7
depends:
    base-4.17.2.1 comonad-5.0.9-9ngCkSDh5y9BpyY9uXawb containers-0.6.7
    data-fix-0.3.4-CBrzdR2JmQ7F35VN8QKSUS
    free-5.2-1lY89dVRqU3DINjOp0WOkW template-haskell-2.19.0.0
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-recursion-schemes/html/recursion-schemes.haddock

haddock-html:         /usr/share/doc/haskell-recursion-schemes/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

