#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.2
visibility:           public
id:                   ral-0.2.2-6tucI19X7Rh2oethBuPJAh
key:                  ral-0.2.2-6tucI19X7Rh2oethBuPJAh
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  5ad157d9bc2c9775aae10cab2091987b
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.2-6tucI19X7Rh2oethBuPJAh
depends:
    QuickCheck-2.15.0.1-9BbRJGxXLRp2lnC2CpyIBM
    adjunctions-4.4.3-FIQAAEAuMfXHk5IwIVgPkw base-4.17.2.1
    bin-0.1.4-LEUtbO9BvgV7DcE7gd7a8v
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P deepseq-1.4.8.0
    distributive-0.6.2.1-HZz2SBscjHIKc511jM0wNj
    fin-0.3.2-IR6fygGSvMRLlKTpJAQ38b
    hashable-1.4.5.0-JHGJZlFhSc53NK2NYV614f
    indexed-traversable-0.1.4-1JQoS0W1FKXHtvIno5fsGs
    semigroupoids-6.0.1-DiRpiGMVw5R87vPlhF19iO

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

