#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.2
visibility:           public
id:                   ral-0.2.2-HZkFDkZdKPK2GCX93hhyyw
key:                  ral-0.2.2-HZkFDkZdKPK2GCX93hhyyw
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  6e9a11aa28ce6529033422386d7abf81
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.2-HZkFDkZdKPK2GCX93hhyyw
depends:
    QuickCheck-2.15.0.1-2V16aMn7v18E3ENFZVoJpj
    adjunctions-4.4.3-74fOmoBbuEb8apv2WxJPmC base-4.17.2.1
    bin-0.1.4-EaGOSMa3vw63wlcWouS4nl
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P deepseq-1.4.8.0
    distributive-0.6.2.1-H2SZC2c21mWIPC9Ih6JR9X
    fin-0.3.2-LxfznGcQcreKcVFrRbG3CL
    hashable-1.4.5.0-tUQ3ISdCwwAzRS3LRBhXn
    indexed-traversable-0.1.4-BQcRr3W4PxWCuaKGpNnbu1
    semigroupoids-6.0.1-EtstizQFZrIGQw5mSEZWn3

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

