#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.2
visibility:           public
id:                   ral-0.2.2-8IDtY10euAAJY7766GLQPC
key:                  ral-0.2.2-8IDtY10euAAJY7766GLQPC
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  0973bb87f93f251a1c166ba3e4418f9d
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.2-8IDtY10euAAJY7766GLQPC
depends:
    QuickCheck-2.15.0.1-5w6er91snjk1ibuLJ886ps
    adjunctions-4.4.3-D3C7qzR73Ap6A4FHJ6OYuX base-4.17.2.1
    bin-0.1.4-E2zFq3afHlWAMFxhTYtZWJ
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P deepseq-1.4.8.0
    distributive-0.6.2.1-AQvcAkjtWDD1atJ9niIiJT
    fin-0.3.2-JGKBz6NKSUwHjyXv8f8Kjo
    hashable-1.4.4.0-GXwYNb6ixbL0AOxKKxOK7
    indexed-traversable-0.1.4-IdrLHXCvQGN9TboScqmWoy
    semigroupoids-6.0.1-6WhHJo1U8WlHQ4cwxv98KH

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

