#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-3g2slt400J02d2Pv5V36XT
key:                  ral-0.2.1-3g2slt400J02d2Pv5V36XT
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  1d5803f387c6b7cc711d8fe5e8d3d566
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-3g2slt400J02d2Pv5V36XT
depends:
    QuickCheck-2.14.3-1roXk93057vCM76NaUaTTz
    adjunctions-4.4.3-6SXbBLnu9PBIp6YWvIqhsY base-4.17.2.1
    bin-0.1.4-JTPhrybaNI05bE2sZx3TEV
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P deepseq-1.4.8.0
    distributive-0.6.2.1-EkCA849v7Xz7JjUK4vYFJS
    fin-0.3.2-1IpcNzTJGOo3kLPz6FiLYI
    hashable-1.4.4.0-C1fFIG7AZLC7j0jzLm97Uw
    indexed-traversable-0.1.4-2T176InstcMqAaY6WCojl
    semigroupoids-6.0.1-FMYBJOyO4ro7UvayiHjr7b

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

