#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-IVQHLVLJfYGEDbr9s3iQX2
key:                  ral-0.2.1-IVQHLVLJfYGEDbr9s3iQX2
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  22df4ef3f8ff5d8c3f29f2d30b0d2a19
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-IVQHLVLJfYGEDbr9s3iQX2
depends:
    QuickCheck-2.14.3-2QKb6Hom0yuuAm9FvZ6nN
    adjunctions-4.4.3-6SKHbkZyiLNHUViFeYiPKB base-4.17.2.1
    bin-0.1.4-tCpOADjlnS77qM2sfoIyd boring-0.2.2-HI9VvaC9JR142cnMpyID0P
    deepseq-1.4.8.0 distributive-0.6.2.1-202InOOCyaJ6mKu3oixMmU
    fin-0.3.2-7egBKFBOGNj1YFvpHdMpX
    hashable-1.4.4.0-CTf4tWLvOCwE4B8hp3PoEK
    indexed-traversable-0.1.4-9eY2jWX2flnImgSA45MGyH
    semigroupoids-6.0.1-Hpl2w1yb41T5HDSvGCGr5x

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

