#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-1q5DKVMObE8GF7Wz9A8POC
key:                  ral-0.2.1-1q5DKVMObE8GF7Wz9A8POC
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  f3f68fce6edd72e8f7a1e1fe050f2bcc
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-1q5DKVMObE8GF7Wz9A8POC
depends:
    QuickCheck-2.14.3-EKHs0Bckxv35uqjg7I4YbU
    adjunctions-4.4.3-L23jtVSlY7O7tGQHYM0INy base-4.17.2.1
    bin-0.1.4-B4MnsvwXm8v9MuCoixVYLb
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P deepseq-1.4.8.0
    distributive-0.6.2.1-IAn2fsllA095WMf59wtcuj
    fin-0.3.2-Ewdd6lT5Go9D3Esrcb1Op
    hashable-1.4.4.0-4IkOt4KzeSSA3Xc4u5PLaT
    indexed-traversable-0.1.4-FpAcbJlkQDVBCnOnkgXYhG
    semigroupoids-6.0.1-Ke2KEMvVUQi8hdEy7uC3Su

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

