#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-instances
version:              0.3.33
visibility:           public
id:                   quickcheck-instances-0.3.33-KtI0elfRWdl8rwN4wscJrx
key:                  quickcheck-instances-0.3.33-KtI0elfRWdl8rwN4wscJrx
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  8a79ca1c4d2491b9936ba95d9aadcb33
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.33
library-dirs:         /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.33
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.33
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.33-KtI0elfRWdl8rwN4wscJrx
depends:
    OneTuple-0.4.2-3jABL9MmeJxJwRdV7WHNQA
    QuickCheck-2.15.0.1-H5XTn9FxFUBGcmB1c3fPtp array-0.5.4.0
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4P9iCjJMWMIHxNOvyaASZG containers-0.6.7
    data-fix-0.3.4-7CDCOIhpvJAI6fy7F7AnJ6
    hashable-1.4.6.0-8MG0S5dfyXU6lRGLMgbs1l
    integer-logarithms-1.0.4-DvBPJWsRhMnDX7YjcDkG3M
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    primitive-0.9.1.0-BPFoIcduUog2ja2MaonOAo
    scientific-0.3.8.0-5k7RkjOpOBv4OfSmUBfqB5
    splitmix-0.1.2-E4vMHkQUSMf9nVBmgOqYuV
    strict-0.5-6fp74gBmFCzCkSWcfcTB3y
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    text-short-0.1.6-667XBtk7wjZ44SMyYYC3F0
    these-1.2.1-8mrzQA4ZRRj2d4hazdVbNv
    time-compat-1.9.7-DjtrQVIcrwxl1HuxZ525o transformers-0.5.6.2
    unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    uuid-types-1.0.6-IGyFyQMVE7yLGAmmia1Sfz
    vector-0.13.2.0-89nHvRrlFmk5zBBEvFgHzR

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

