#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-instances
version:              0.3.32
visibility:           public
id:                   quickcheck-instances-0.3.32-9fs9Yyy6nPeDEN9wsB2Nj9
key:                  quickcheck-instances-0.3.32-9fs9Yyy6nPeDEN9wsB2Nj9
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  05c87159d9fecda2c065ce9af23a53a3
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.32
library-dirs:         /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.32
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.32
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.32-9fs9Yyy6nPeDEN9wsB2Nj9
depends:
    OneTuple-0.4.2-DCyJUR8GMAF33aLYSt1izk
    QuickCheck-2.14.3-CEKfXt0vIE49fVERCVjkfD array-0.5.4.0
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-9yImpzTIYpBJ0v1fZqtWOj containers-0.6.7
    data-fix-0.3.4-IAuVQTTnwSS16SuXmOC0dd
    hashable-1.4.4.0-EdBgVbn6YIuE9bA3dwmz04
    integer-logarithms-1.0.4-L2GD4jWPMZsJxsIQTBgtzb
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    primitive-0.9.1.0-1qcn44iT2KcGW7CVhBZc50
    scientific-0.3.8.0-5VCcSe8kMhaKTje3aOa6OL
    splitmix-0.1.2-BPXbQkwTmbEHuTj8vXXGVm
    strict-0.5-5S2Hv5VByEv5UTm7TvuEQq
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    text-short-0.1.6-JKBEzsPWYHRLnQg5mcamup
    these-1.2.1-4KbGC1j5TgjKOAxv2nIECx
    time-compat-1.9.7-5r5EVE9BYA2F9wnN6eblWx transformers-0.5.6.2
    unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    uuid-types-1.0.6-AbsLvP6OB455DAJC5Zy4SR
    vector-0.13.2.0-4gUGda2ISIbCv9ACnxMPCL

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

