#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-instances
version:              0.3.30
visibility:           public
id:                   quickcheck-instances-0.3.30-Gep1FPhuFDpBkIaIFd2YnM
key:                  quickcheck-instances-0.3.30-Gep1FPhuFDpBkIaIFd2YnM
license:              BSD-3-Clause
copyright:            Copyright 2012-2016 Antoine Latter, 2017-2019 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Antoine Latter <aslatter@gmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/qc-instances
synopsis:             Common quickcheck instances
description:
    QuickCheck instances.

    The goal is to supply QuickCheck instances for
    types provided by the Haskell Platform.

    Since all of these instances are provided as
    orphans, I recommend that you do not use this library
    within another library module, so that you don'\''t
    impose these instances on down-stream consumers of
    your code.

category:             Testing
abi:                  9dc608a971715fbd3d786b68fb7d4ac8
exposed:              True
exposed-modules:
    Test.QuickCheck.Instances Test.QuickCheck.Instances.Array
    Test.QuickCheck.Instances.Array.Byte
    Test.QuickCheck.Instances.ByteString
    Test.QuickCheck.Instances.CaseInsensitive
    Test.QuickCheck.Instances.Containers
    Test.QuickCheck.Instances.DataFix
    Test.QuickCheck.Instances.Hashable
    Test.QuickCheck.Instances.Natural Test.QuickCheck.Instances.OldTime
    Test.QuickCheck.Instances.Primitive
    Test.QuickCheck.Instances.Scientific
    Test.QuickCheck.Instances.Semigroup Test.QuickCheck.Instances.Solo
    Test.QuickCheck.Instances.Strict Test.QuickCheck.Instances.Tagged
    Test.QuickCheck.Instances.Text Test.QuickCheck.Instances.Text.Short
    Test.QuickCheck.Instances.These Test.QuickCheck.Instances.Time
    Test.QuickCheck.Instances.Transformer
    Test.QuickCheck.Instances.UUID
    Test.QuickCheck.Instances.UnorderedContainers
    Test.QuickCheck.Instances.Vector Test.QuickCheck.Instances.Void

hidden-modules:       Test.QuickCheck.Instances.CustomPrelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
library-dirs:         /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/quickcheck-instances-0.3.30
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-instances
hs-libraries:         HSquickcheck-instances-0.3.30-Gep1FPhuFDpBkIaIFd2YnM
depends:
    OneTuple-0.4.2-H2hq3WX7vAYH5Mde32s1b7
    QuickCheck-2.14.3-7hqZHxjEzJA3sWW6zgGwOZ array-0.5.4.0
    base-4.17.2.1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-1ILAtZHAjAqgINNQwApUo containers-0.6.7
    data-fix-0.3.4-B1IhiJz7xaJ1xVSkhKWXkK
    hashable-1.4.4.0-HCL6HYi7vZb6weAXUagHtJ
    integer-logarithms-1.0.4-1FY4syndAdJKzfO6pz9SxS
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    primitive-0.9.1.0-4og3N5b6tAb1VUfCmYprp3
    scientific-0.3.7.0-58CM7xG7oFa5aLaqCWIm5T
    splitmix-0.1.0.5-Li6N9Hrf3ipJy1YAPUWahV
    strict-0.5-3Ncmrj5Y4MrG5RHCr6k4Q3
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    text-short-0.1.6-7UHmRIV0Q9RCuRJBKZCz95
    these-1.2.1-B2etgjfFQvt5rgn4CEUsvB time-1.12.2
    time-compat-1.9.6.1-Kim6on0z72L1W8iGd9JuuW transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ
    unordered-containers-0.2.20-8JBL18W4zya10WTL7b71WH
    uuid-types-1.0.6-6FLYcTfohLW9ZMpOL5wTYB
    vector-0.13.2.0-HroDrH7PuHaEuK3uU9gvoU

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-instances/html/quickcheck-instances.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

