#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 quickcheck-classes-base
version:              0.6.2.0
visibility:           public
id:                   quickcheck-classes-base-0.6.2.0-3bpUr3Oojn4BKwm9t0OuRQ
key:                  quickcheck-classes-base-0.6.2.0-3bpUr3Oojn4BKwm9t0OuRQ
license:              BSD-3-Clause
copyright:            2019 Andrew Martin
maintainer:           andrew.thaddeus@gmail.com
author:               Andrew Martin, chessai
homepage:             https://github.com/andrewthad/quickcheck-classes#readme
synopsis:             QuickCheck common typeclasses from `base`
description:
    This libary is a minimal variant of `quickcheck-classes` that
    only provides laws for typeclasses from `base`. The main purpose
    of splitting this out is so that `primitive` can depend on
    `quickcheck-classes-base` in its test suite, avoiding the circular
    dependency that arises if `quickcheck-classes` is used instead.

    This library provides QuickCheck properties to ensure
    that typeclass instances adhere to the set of laws that
    they are supposed to. There are other libraries that do
    similar things, such as `genvalidity-hspec` and `checkers`.
    This library differs from other solutions by not introducing
    any new typeclasses that the user needs to learn.

    /Note:/ on GHC < 8.5, this library uses the higher-kinded typeclasses
    ('\''Data.Functor.Classes.Show1'\'', '\''Data.Functor.Classes.Eq1'\'', '\''Data.Functor.Classes.Ord1'\'', etc.),
    but on GHC >= 8.5, it uses `-XQuantifiedConstraints` to express these
    constraints more cleanly.

category:             Testing
abi:                  bf8c9462dde484e679f2a25258d05679
exposed:              True
exposed-modules:
    Test.QuickCheck.Classes.Base Test.QuickCheck.Classes.Base.IsList
    Test.QuickCheck.Classes.Internal

hidden-modules:
    Test.QuickCheck.Classes.Alternative
    Test.QuickCheck.Classes.Applicative
    Test.QuickCheck.Classes.Bifoldable
    Test.QuickCheck.Classes.Bifunctor
    Test.QuickCheck.Classes.Bitraversable Test.QuickCheck.Classes.Bits
    Test.QuickCheck.Classes.Category
    Test.QuickCheck.Classes.Contravariant Test.QuickCheck.Classes.Enum
    Test.QuickCheck.Classes.Eq Test.QuickCheck.Classes.Foldable
    Test.QuickCheck.Classes.Functor Test.QuickCheck.Classes.Generic
    Test.QuickCheck.Classes.Integral Test.QuickCheck.Classes.Ix
    Test.QuickCheck.Classes.Monad Test.QuickCheck.Classes.MonadFail
    Test.QuickCheck.Classes.MonadPlus Test.QuickCheck.Classes.MonadZip
    Test.QuickCheck.Classes.Monoid Test.QuickCheck.Classes.Num
    Test.QuickCheck.Classes.Ord Test.QuickCheck.Classes.Semigroup
    Test.QuickCheck.Classes.Show Test.QuickCheck.Classes.ShowRead
    Test.QuickCheck.Classes.Storable
    Test.QuickCheck.Classes.Traversable

import-dirs:
    /usr/lib/ghc-9.4.8/site-local/quickcheck-classes-base-0.6.2.0

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/quickcheck-classes-base-0.6.2.0

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/quickcheck-classes-base-0.6.2.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-quickcheck-classes-base
hs-libraries:         HSquickcheck-classes-base-0.6.2.0-3bpUr3Oojn4BKwm9t0OuRQ
depends:
    QuickCheck-2.14.3-EZ7TdgRzq7jKBweVl9M0jh base-4.17.2.1
    containers-0.6.7 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-quickcheck-classes-base/html/quickcheck-classes-base.haddock

haddock-html:         /usr/share/doc/haskell-quickcheck-classes-base/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

