#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pipes-safe
version:              2.3.5
visibility:           public
id:                   pipes-safe-2.3.5-IHHgj5d3wjFLd2fTHa6uRM
key:                  pipes-safe-2.3.5-IHHgj5d3wjFLd2fTHa6uRM
license:              BSD-3-Clause
copyright:            2013, 2014 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Safety for the pipes ecosystem
description:
    This package adds resource management and exception handling to the @pipes@
    ecosystem.

    Notable features include:

    * /Resource Safety/: Guarantee finalization using @finally@, @bracket@ and
    more

    * /Exception Safety/: Even against asynchronous exceptions!

    * /Laziness/: Only acquire resources when you need them

    * /Promptness/: Finalize resources early when you are done with them

    * /Native Exception Handling/: Catch and resume from exceptions inside pipes

    * /No Buy-in/: Mix resource-safe pipes with unmanaged pipes using @hoist@

category:             Control, Pipes, Error Handling
abi:                  99ea2d9bb78416c0f3c15ca70ba247aa
exposed:              True
exposed-modules:      Pipes.Safe Pipes.Safe.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pipes-safe
hs-libraries:         HSpipes-safe-2.3.5-IHHgj5d3wjFLd2fTHa6uRM
depends:
    base-4.17.2.1 containers-0.6.7 exceptions-0.10.5
    monad-control-1.0.3.1-9zo0UMe5gnjLVD9yuioV4p mtl-2.2.2
    pipes-4.3.16-C8d0Mfm7kepEuUN9jo24kO
    primitive-0.9.1.0-IHF3DoB9Qq2KNGfApZUSXg transformers-0.5.6.2
    transformers-base-0.4.6-IVRZleaMDzKEedIMfGoDoK

haddock-interfaces:   /usr/share/doc/haskell-pipes-safe/html/pipes-safe.haddock
haddock-html:         /usr/share/doc/haskell-pipes-safe/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

