#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pipes-safe
version:              2.3.5
visibility:           public
id:                   pipes-safe-2.3.5-AVeCE2oSCaM6miUCuHUhJf
key:                  pipes-safe-2.3.5-AVeCE2oSCaM6miUCuHUhJf
license:              BSD-3-Clause
copyright:            2013, 2014 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Safety for the pipes ecosystem
description:
    This package adds resource management and exception handling to the @pipes@
    ecosystem.

    Notable features include:

    * /Resource Safety/: Guarantee finalization using @finally@, @bracket@ and
    more

    * /Exception Safety/: Even against asynchronous exceptions!

    * /Laziness/: Only acquire resources when you need them

    * /Promptness/: Finalize resources early when you are done with them

    * /Native Exception Handling/: Catch and resume from exceptions inside pipes

    * /No Buy-in/: Mix resource-safe pipes with unmanaged pipes using @hoist@

category:             Control, Pipes, Error Handling
abi:                  6241bc06086c13588041e34939c627c8
exposed:              True
exposed-modules:      Pipes.Safe Pipes.Safe.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pipes-safe
hs-libraries:         HSpipes-safe-2.3.5-AVeCE2oSCaM6miUCuHUhJf
depends:
    base-4.17.2.1 containers-0.6.7 exceptions-0.10.5
    monad-control-1.0.3.1-ADBy113jPZx6EyMvvTxyI9 mtl-2.2.2
    pipes-4.3.16-1kG1fyhd8hS3YRVCeEMtXR
    primitive-0.9.1.0-3L6fSIJx0fWJUtVHVLpgAb transformers-0.5.6.2
    transformers-base-0.4.6-5fKXdbxww34Jppu8NGc4jg

haddock-interfaces:   /usr/share/doc/haskell-pipes-safe/html/pipes-safe.haddock
haddock-html:         /usr/share/doc/haskell-pipes-safe/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

