#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pipes-safe
version:              2.3.5
visibility:           public
id:                   pipes-safe-2.3.5-EJ0hccQXrLH9LbYjWmdoxV
key:                  pipes-safe-2.3.5-EJ0hccQXrLH9LbYjWmdoxV
license:              BSD-3-Clause
copyright:            2013, 2014 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Safety for the pipes ecosystem
description:
    This package adds resource management and exception handling to the @pipes@
    ecosystem.

    Notable features include:

    * /Resource Safety/: Guarantee finalization using @finally@, @bracket@ and
    more

    * /Exception Safety/: Even against asynchronous exceptions!

    * /Laziness/: Only acquire resources when you need them

    * /Promptness/: Finalize resources early when you are done with them

    * /Native Exception Handling/: Catch and resume from exceptions inside pipes

    * /No Buy-in/: Mix resource-safe pipes with unmanaged pipes using @hoist@

category:             Control, Pipes, Error Handling
abi:                  06bdd30bf98d1e23d9298e42466e234d
exposed:              True
exposed-modules:      Pipes.Safe Pipes.Safe.Prelude
import-dirs:          /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pipes-safe-2.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pipes-safe
hs-libraries:         HSpipes-safe-2.3.5-EJ0hccQXrLH9LbYjWmdoxV
depends:
    base-4.17.2.1 containers-0.6.7 exceptions-0.10.5
    monad-control-1.0.3.1-5d82eYalKzB1lBE27TbkgK mtl-2.2.2
    pipes-4.3.16-4YCnlwlj8LZ2f77SqOzfil
    primitive-0.9.0.0-7BIYbmztPZn4k2gFg33YHr transformers-0.5.6.2
    transformers-base-0.4.6-411BkTw86QqB7n6xMIgJ6x

haddock-interfaces:   /usr/share/doc/haskell-pipes-safe/html/pipes-safe.haddock
haddock-html:         /usr/share/doc/haskell-pipes-safe/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

