#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   pango
version:                0.13.11.0
visibility:             public
id:                     pango-0.13.11.0-80Xvtc2MIVA569uP2edF1N
key:                    pango-0.13.11.0-80Xvtc2MIVA569uP2edF1N
license:                LGPL-2.1-only
copyright:              (c) 2001-2010 The Gtk2Hs Team
maintainer:             gtk2hs-users@lists.sourceforge.net
author:                 Axel Simon, Duncan Coutts
stability:              stable
homepage:               http://projects.haskell.org/gtk2hs/
synopsis:               Binding to the Pango text rendering engine.
description:
    This package provides a wrapper around the Pango C library that
    allows high-quality rendering of Unicode text. It can be used
    either with Cairo to output text in PDF, PS or other
    documents or with Gtk+ to display text on-screen.

category:               Graphics
abi:                    60af48e3777d720703cea8f619e2a00c
exposed:                True
exposed-modules:
    Graphics.Rendering.Pango Graphics.Rendering.Pango.Attributes
    Graphics.Rendering.Pango.BasicTypes Graphics.Rendering.Pango.Cairo
    Graphics.Rendering.Pango.Context Graphics.Rendering.Pango.Enums
    Graphics.Rendering.Pango.Font Graphics.Rendering.Pango.Layout
    Graphics.Rendering.Pango.Markup Graphics.Rendering.Pango.Rendering
    Graphics.Rendering.Pango.Structs Graphics.Rendering.Pango.Types

hidden-modules:
    Graphics.Rendering.Pango.GlyphStorage
    Graphics.Rendering.Pango.Description

import-dirs:            /usr/lib/ghc-9.4.8/site-local/pango-0.13.11.0
library-dirs:           /usr/lib/ghc-9.4.8/site-local/pango-0.13.11.0
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/pango-0.13.11.0
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-pango
hs-libraries:           HSpango-0.13.11.0-80Xvtc2MIVA569uP2edF1N
extra-libraries:
    pangocairo-1.0 pango-1.0 gobject-2.0 cairo harfbuzz glib-2.0

extra-libraries-static:
    pangocairo-1.0 m pangoft2-1.0 m harfbuzz-gobject pango-1.0 m
    gio-2.0 gobject-2.0 ffi gmodule-2.0 mount blkid fribidi thai datrie
    Xft cairo m dl fontconfig m expat m freetype bz2 png16 m m z
    harfbuzz m glib-2.0 m pcre2-8 graphite2 brotlidec brotlicommon Xext
    Xrender X11 pthread xcb-render xcb-shm xcb Xau Xdmcp pixman-1 m
    sysprof-capture-4

include-dirs:
    /usr/include/pango-1.0 /usr/include/harfbuzz /usr/include/libmount
    /usr/include/blkid /usr/include/fribidi /usr/include/cairo
    /usr/include/freetype2 /usr/include/libpng16 /usr/include/glib-2.0
    /usr/lib/glib-2.0/include /usr/include/pixman-1
    /usr/include/sysprof-6

includes:               hspango.h
depends:
    array-0.5.4.0 base-4.17.2.1 cairo-0.13.11.0-85PiMv8ydr2DQWH696LimN
    containers-0.6.7 directory-1.3.7.1
    glib-0.13.11.0-DEMgnBehjUuHVH87kUo9AC mtl-2.2.2 pretty-1.1.3.6
    process-1.6.18.0 text-2.0.2

haddock-interfaces:     /usr/share/doc/haskell-pango/html/pango.haddock
haddock-html:           /usr/share/doc/haskell-pango/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

