#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-pandoc-z-xml-light
version:              3.2
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.2-BaWXoBQvHhn1zbD2QtKwL4-xml-light
key:                  pandoc-3.2-BaWXoBQvHhn1zbD2QtKwL4-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  e522c36fa8397183ae5c5d7a0a797cd1
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/pandoc-3.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pandoc-3.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pandoc-3.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.2-BaWXoBQvHhn1zbD2QtKwL4-xml-light
depends:
    base-4.17.2.1 containers-0.6.7 text-2.0.2
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-KElFGaHf96E1O2VwBID5qq
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pandoc
version:              3.2
visibility:           public
id:                   pandoc-3.2-Fc24JwC5AA9BmFJh2Ka7ZW
key:                  pandoc-3.2-Fc24JwC5AA9BmFJh2Ka7ZW
license:              GPL-2.0-or-later
copyright:            (c) 2006-2024 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags, djot)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized
    extensively using templates, filters, and custom readers
    and writers written in Lua.

    For the pandoc command-line program, see the
    @pandoc-cli@ package.

category:             Text
abi:                  cad64ec96ceb356be0be2cfc56f34eb5
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.Djot Text.Pandoc.Readers.DocBook
    Text.Pandoc.Readers.Docx Text.Pandoc.Readers.DokuWiki
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.EndNote
    Text.Pandoc.Readers.FB2 Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.Ipynb
    Text.Pandoc.Readers.JATS Text.Pandoc.Readers.Jira
    Text.Pandoc.Readers.LaTeX Text.Pandoc.Readers.Man
    Text.Pandoc.Readers.Markdown Text.Pandoc.Readers.MediaWiki
    Text.Pandoc.Readers.Muse Text.Pandoc.Readers.Native
    Text.Pandoc.Readers.ODT Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Org Text.Pandoc.Readers.RIS
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.RTF
    Text.Pandoc.Readers.TWiki Text.Pandoc.Readers.Textile
    Text.Pandoc.Readers.TikiWiki Text.Pandoc.Readers.Txt2Tags
    Text.Pandoc.Readers.Typst Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Transforms Text.Pandoc.Translations
    Text.Pandoc.Translations.Types Text.Pandoc.UTF8 Text.Pandoc.Version
    Text.Pandoc.Writers Text.Pandoc.Writers.AnnotatedTable
    Text.Pandoc.Writers.AsciiDoc Text.Pandoc.Writers.BibTeX
    Text.Pandoc.Writers.ChunkedHTML Text.Pandoc.Writers.CommonMark
    Text.Pandoc.Writers.ConTeXt Text.Pandoc.Writers.CslJson
    Text.Pandoc.Writers.Djot Text.Pandoc.Writers.DocBook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.Ipynb
    Text.Pandoc.Writers.JATS Text.Pandoc.Writers.Jira
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.Typst Text.Pandoc.Writers.XWiki
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Symbols Text.Pandoc.Readers.Docx.Fields
    Text.Pandoc.Readers.HTML.Parsing Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.Typst.Parsing
    Text.Pandoc.Readers.Typst.Math Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.StyleMap
    Text.Pandoc.Writers.Docx.Table Text.Pandoc.Writers.Docx.Types
    Text.Pandoc.Writers.GridTable Text.Pandoc.Writers.JATS.References
    Text.Pandoc.Writers.JATS.Table Text.Pandoc.Writers.JATS.Types
    Text.Pandoc.Writers.LaTeX.Caption Text.Pandoc.Writers.LaTeX.Notes
    Text.Pandoc.Writers.LaTeX.Table Text.Pandoc.Writers.LaTeX.Lang
    Text.Pandoc.Writers.LaTeX.Types Text.Pandoc.Writers.LaTeX.Citation
    Text.Pandoc.Writers.LaTeX.Util Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.TeX
    Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/pandoc-3.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/pandoc-3.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/pandoc-3.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.2-Fc24JwC5AA9BmFJh2Ka7ZW
depends:
    Glob-0.10.2-EXjlSbqCMco1wUiI4xq3V7
    JuicyPixels-3.3.9-E0tbWQJPjFg3b5l3NKZswv
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-wY4CXNP4Ti6TCaMY1tyMf
    aeson-pretty-0.8.10-FF3kbqs1WvtKfkblP58Xcl array-0.5.4.0
    attoparsec-0.14.4-GTfBnxih117FV8L70A8efO base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb binary-0.8.9.1
    blaze-html-0.9.2.0-4nZEIuSQm5uJHuPTchkOVN
    blaze-markup-0.8.3.0-1slEV1JTVXCHBVRvUtps3k bytestring-0.11.5.3
    case-insensitive-1.2.1.0-A6Av13j1PriHVZgHNthY8h
    citeproc-0.8.1.1-C1fRey7uyMaDK0q8A9JUoD
    commonmark-0.2.6-LMC0OkpePCZ9PiVJQv1cTX
    commonmark-extensions-0.2.5.5-2cDm2hKB4Fb8FVlBo6skhE
    commonmark-pandoc-0.2.2.2-8lafakZIKfeKgrXl4yiPwO containers-0.6.7
    crypton-connection-0.4.3-F6Kb3egvYmf2J1BBuYGANs
    crypton-x509-system-1.6.7-G5JodxU0YwzL0FkUDiD1U
    data-default-0.7.1.2-LONLsSvT4G81IL8ks6Ql72 deepseq-1.4.8.0
    directory-1.3.7.1 djot-0.1.2.1-2LdphpAXRn12z116U1zNJb
    doclayout-0.4.0.1-GUoJC0789ivIrg43gjVtj5
    doctemplates-0.11.0.1-Hr1m5B6ouYu9FCvBdWSuP1
    emojis-0.1.4.1-GsPqDvY8sjR97EGs21xpKB exceptions-0.10.5
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    gridtables-0.1.0.0-C2d6IOg4O61FjFk6f22IU9
    haddock-library-1.11.0-Km2mTaRHzfjKlLo6uzEm3H
    http-client-0.7.19-C1MyFeZ6J0U64oNAVz8qWH
    http-client-tls-0.3.6.4-2UCAQd74svUAKy6rR9fBGJ
    http-types-0.12.4-75PPyaYnKWt41SOfuGm1SN
    ipynb-0.2-Evqh7tWuuqeJQ58BKCUaqO
    jira-wiki-markup-1.5.1-KpULPkOYcgVJ796mGaEIdD
    mime-types-0.1.2.0-3JrdaebXJwiILES3glDFuq mtl-2.2.2
    network-3.1.4.0-18zdZgmnDKE1J4Hp557YCB
    network-uri-2.6.4.2-95fWnkSq4twGVejB9ewxKe
    pandoc-3.2-BaWXoBQvHhn1zbD2QtKwL4-xml-light
    pandoc-types-1.23.1-3CNRolnghLrGrKUxTKh94B parsec-3.1.16.1
    pretty-1.1.3.6 pretty-show-1.10-Ey6CADemQl3EFi7OIHqHDp
    process-1.6.18.0 random-1.2.1.3-7z4mPLTBPidE9rbVioKqnW
    safe-0.3.21-8UNW4gIoNRmKgGFufdPOla
    scientific-0.3.8.0-DLDr5nembSsHeUMWxBP2Rn
    skylighting-0.14.2-5SEby1WuwX14Wl989wMJEU
    skylighting-core-0.14.2-68IvbucFBVnB6KXoJAAGZy
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV syb-0.7.3-BQUcn35RmaZ45KQPDd3rN
    tagsoup-0.14.8-GVtsPXOGcnkEcwEFDhng0m
    temporary-1.3-3NOXbZBNm6jw25HF8dLG0
    texmath-0.12.8.9-RmyqlxMp1UDcEliGze6c8 text-2.0.2
    text-conversions-0.3.1.1-2IPrT11TT9zI0Ox5yDDJe6 time-1.12.2
    tls-2.0.6-3ATycKdNDQxLVc6Nb7Y4sS
    typst-0.5.0.4-ACB5msbG63LeWtuG0nPNC
    unicode-collation-0.1.3.6-BCg3F9AOvLYGVdfxYqBzsp
    unicode-transforms-0.4.0.1-36v4gmxQ5q9Jsw4Mt9WolA unix-2.7.3
    vector-0.13.2.0-B5pfN7kp2sVHpMWItbJQ58
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    yaml-0.11.11.2-2rPjyCaPXyz9XPAN7vzk92
    zip-archive-0.4.3.2-9H2J7WnqG5zGfDIFVtl5Gy
    zlib-0.7.0.0-3VB0JcHQ0YdEzhd22eQVSI

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

