#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 optparse-applicative
version:              0.18.1.0
visibility:           public
id:                   optparse-applicative-0.18.1.0-JuQoOrwWN8S21l8m3o2pvN
key:                  optparse-applicative-0.18.1.0-JuQoOrwWN8S21l8m3o2pvN
license:              BSD-3-Clause
copyright:            (c) 2012-2017 Paolo Capriotti <paolo@capriotti.io>
maintainer:           huw.campbell@gmail.com
author:               Paolo Capriotti, Huw Campbell
homepage:             https://github.com/pcapriotti/optparse-applicative
synopsis:             Utilities and combinators for parsing command line options
description:
    optparse-applicative is a haskell library for parsing options
    on the command line, and providing a powerful applicative
    interface for composing them.

    optparse-applicative takes care of reading and validating the
    arguments passed to the command line, handling and reporting
    errors, generating a usage line, a comprehensive help screen,
    and enabling context-sensitive bash, zsh, and fish completions.

    See the included README for detailed instructions and examples,
    which is also available on github
    <https://github.com/pcapriotti/optparse-applicative>.

category:             System, CLI, Options, Parsing
abi:                  99c6e2b5ed4e254f770e6d7e8d249177
exposed:              True
exposed-modules:
    Options.Applicative Options.Applicative.Arrows
    Options.Applicative.BashCompletion Options.Applicative.Builder
    Options.Applicative.Builder.Completer
    Options.Applicative.Builder.Internal Options.Applicative.Common
    Options.Applicative.Extra Options.Applicative.Help
    Options.Applicative.Help.Chunk Options.Applicative.Help.Core
    Options.Applicative.Help.Levenshtein
    Options.Applicative.Help.Pretty Options.Applicative.Help.Types
    Options.Applicative.Internal Options.Applicative.NonEmpty
    Options.Applicative.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/optparse-applicative-0.18.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/optparse-applicative-0.18.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/optparse-applicative-0.18.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-optparse-applicative
hs-libraries:         HSoptparse-applicative-0.18.1.0-JuQoOrwWN8S21l8m3o2pvN
depends:
    base-4.17.2.1 prettyprinter-1.7.1-EqfzrdoXeXwBZWVdz9UKUZ
    prettyprinter-ansi-terminal-1.1.3-2kAqCIFmqyI2b54jwtSYDP
    process-1.6.18.0 text-2.0.2 transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ

haddock-interfaces:
    /usr/share/doc/haskell-optparse-applicative/html/optparse-applicative.haddock

haddock-html:         /usr/share/doc/haskell-optparse-applicative/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

