#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 named-text
version:              1.2.1.0
visibility:           public
id:                   named-text-1.2.1.0-CXLHZCVDVrd92FnSsEg5Ea
key:                  named-text-1.2.1.0-CXLHZCVDVrd92FnSsEg5Ea
license:              ISC
copyright:            Galois Inc, 2023
maintainer:           kquick@galois.com
author:               Kevin Quick
synopsis:
    A parameterized named text type and associated functionality.

description:

    A plain String or Text is dangerous because it can be arbitrarily combined,
    converted, emitted, and updated without consideration of the validity and
    applicability of the contents and the usage scenario.

    This module provides a Named type wrapper around Text which has two
    additional type parameters: one which indicates what the content of the Text
    represents, and one which indicates the style of the name.

    There are additionally functions and classes which allow conversions and
    transformations between names with different styles and types (or disallow them
    where appropriate).

    The core intent of this library is that the Named is used instead of a raw
    String or Text to provide type-level tracking and safety.

category:             Data
abi:                  769318bf9a1fe8f466f81533720064b1
exposed:              True
exposed-modules:      Data.Name Data.Name.JSON
hidden-modules:       Data.Name.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/named-text-1.2.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/named-text-1.2.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/named-text-1.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-named-text
hs-libraries:         HSnamed-text-1.2.1.0-CXLHZCVDVrd92FnSsEg5Ea
depends:
    aeson-2.1.2.1-4XssoWP8s0tKPHSv4bO4jS base-4.17.2.1 deepseq-1.4.8.0
    hashable-1.4.4.0-D3m6G7BPJON5VQ2FLdROoK
    prettyprinter-1.7.1-5ZQmBmwWcWI11K7a8GbhBl
    sayable-1.2.5.0-8oZdnOrYMcmJJMfI7JjnWJ text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-named-text/html/named-text.haddock
haddock-html:         /usr/share/doc/haskell-named-text/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

