#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 multistate
version:              0.8.0.4
visibility:           public
id:                   multistate-0.8.0.4-7KMbteRhP5bB9q5InZzCDn
key:                  multistate-0.8.0.4-7KMbteRhP5bB9q5InZzCDn
license:              BSD-3-Clause
copyright:            Copyright (C) 2013 Jan Bracker, 2013-2020 Lennart Spitzner
maintainer:           Lennart Spitzner <hexagoxel@hexagoxel.de>
author:               Jan Bracker, Lennart Spitzner
stability:            Experimental
homepage:             https://github.com/lspitzner/multistate
synopsis:
    like mtl'\''s ReaderT / WriterT / StateT, but more than one
    contained value/type.

description:
    When using multiple Read\/Write\/State transformers in the same monad stack,
    it becomes necessary to lift the operations in order to affect a specific
    transformer.
    Using heterogeneous lists (and all kinds of GHC extensions magic),
    this package provides transformers that remove that necessity:
    MultiReaderT\/MultiWriterT\/MultiStateT\/MultiRWST can contain a
    heterogeneous list of values.

    See the <https://github.com/lspitzner/multistate README> for
    a longer description.

category:             Control
abi:                  1dd5c49ef2e4b7ee4979f8470e0a40e9
exposed:              True
exposed-modules:
    Control.Monad.Trans.MultiGST Control.Monad.Trans.MultiGST.Lazy
    Control.Monad.Trans.MultiGST.Strict
    Control.Monad.Trans.MultiGet.Class Control.Monad.Trans.MultiRWS
    Control.Monad.Trans.MultiRWS.Lazy
    Control.Monad.Trans.MultiRWS.Strict Control.Monad.Trans.MultiReader
    Control.Monad.Trans.MultiReader.Class
    Control.Monad.Trans.MultiReader.Lazy
    Control.Monad.Trans.MultiReader.Strict
    Control.Monad.Trans.MultiState Control.Monad.Trans.MultiState.Class
    Control.Monad.Trans.MultiState.Lazy
    Control.Monad.Trans.MultiState.Strict
    Control.Monad.Trans.MultiWriter
    Control.Monad.Trans.MultiWriter.Class
    Control.Monad.Trans.MultiWriter.Lazy
    Control.Monad.Trans.MultiWriter.Strict Data.HList.ContainsType
    Data.HList.HList

hidden-modules:       Control.Monad.Trans.MultiGST.Common
import-dirs:          /usr/lib/ghc-9.4.8/site-local/multistate-0.8.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/multistate-0.8.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/multistate-0.8.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-multistate
hs-libraries:         HSmultistate-0.8.0.4-7KMbteRhP5bB9q5InZzCDn
depends:
    base-4.17.2.1 monad-control-1.0.3.1-5nEHKcCw2AKAWnTZQ734RN
    mtl-2.2.2 tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C transformers-0.5.6.2
    transformers-base-0.4.6-CNit6PtxWCSJk45N0kf3SM

haddock-interfaces:   /usr/share/doc/haskell-multistate/html/multistate.haddock
haddock-html:         /usr/share/doc/haskell-multistate/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

