#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 monad-memo
version:              0.5.4
visibility:           public
id:                   monad-memo-0.5.4-2qyBAvpR2Zo6c2RtPz8sCV
key:                  monad-memo-0.5.4-2qyBAvpR2Zo6c2RtPz8sCV
license:              BSD-3-Clause
maintainer:           eduard.sergeev@gmail.com
author:               Eduard Sergeev
homepage:             https://github.com/EduardSergeev/monad-memo
synopsis:             Memoization monad transformer
description:
    Memoization monad transformer supporting most of the standard monad transformers and a range of memoization cache types: from default pure maps to extremely fast mutable vectors

    To add memoization behaviour to a monadic function:

    1) Add '\''Control.Monad.Memo.memo'\'' combinator at the point when memoization is required (i.e. recursive call)

    >import Control.Monad.Memo
    >
    >fibm 0 = return 0
    >fibm 1 = return 1
    >fibm n = do
    >  n1 <- memo fibm (n-1)
    >  n2 <- memo fibm (n-2)
    >  return (n1+n2)

    2) Use appropriate /*eval*/ or /*run*/ function to evaluate resulting `MonadMemo` monad:

    >startEvalMemo (fibm 100)

    See detailed description and examples: "Control.Monad.Memo"

category:             Control, Monad
abi:                  cfe9129763a3b169f8c257377cd45264
exposed:              True
exposed-modules:
    Control.Monad.Memo Control.Monad.Memo.Array
    Control.Monad.Memo.Array.Instances Control.Monad.Memo.Class
    Control.Monad.Memo.Vector Control.Monad.Memo.Vector.Expandable
    Control.Monad.Memo.Vector.Instances
    Control.Monad.Memo.Vector.Unsafe Control.Monad.Trans.Memo.Map
    Control.Monad.Trans.Memo.ReaderCache Control.Monad.Trans.Memo.State
    Control.Monad.Trans.Memo.StateCache Data.MapLike
    Data.MapLike.Instances Data.MaybeLike Data.MaybeLike.Instances

import-dirs:          /usr/lib/ghc-9.4.8/site-local/monad-memo-0.5.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/monad-memo-0.5.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/monad-memo-0.5.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-monad-memo
hs-libraries:         HSmonad-memo-0.5.4-2qyBAvpR2Zo6c2RtPz8sCV
depends:
    array-0.5.4.0 base-4.17.2.1 containers-0.6.7
    primitive-0.9.1.0-KawCla5BA6F2MLtBZRS1Dh transformers-0.5.6.2
    vector-0.13.2.0-3jopdCx3MMLHVSrvHoDH9i

haddock-interfaces:   /usr/share/doc/haskell-monad-memo/html/monad-memo.haddock
haddock-html:         /usr/share/doc/haskell-monad-memo/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

