#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 monad-control
version:              1.0.3.1
visibility:           public
id:                   monad-control-1.0.3.1-6BZrEcXVVy1ERiltg4JMsJ
key:                  monad-control-1.0.3.1-6BZrEcXVVy1ERiltg4JMsJ
license:              BSD-3-Clause
copyright:            (c) 2011 Bas van Dijk, Anders Kaseorg
maintainer:
    Oleg Grenrus <oleg.grenrus@iki.fi>, Bas van Dijk <v.dijk.bas@gmail.com>

author:               Bas van Dijk, Anders Kaseorg
homepage:             https://github.com/basvandijk/monad-control
synopsis:
    Lift control operations, like exception catching, through monad transformers

description:
    This package defines the type class @MonadBaseControl@, a subset of
    @MonadBase@ into which generic control operations such as @catch@ can be
    lifted from @IO@ or any other base monad. Instances are based on monad
    transformers in @MonadTransControl@, which includes all standard monad
    transformers in the @transformers@ library except @ContT@.

    See the <http://hackage.haskell.org/package/lifted-base lifted-base>
    package which uses @monad-control@ to lift @IO@
    operations from the @base@ library (like @catch@ or @bracket@) into any monad
    that is an instance of @MonadBase@ or @MonadBaseControl@.

    Note that this package is a rewrite of Anders Kaseorg'\''s @monad-peel@
    library. The main difference is that this package provides CPS style operators
    and exploits the @RankNTypes@ and @TypeFamilies@ language extensions to
    simplify and speedup most definitions.

category:             Control
abi:                  a96e8e357260d1b7c16ed5d54cc2df2d
exposed:              True
exposed-modules:      Control.Monad.Trans.Control
import-dirs:          /usr/lib/ghc-9.6.6/site-local/monad-control-1.0.3.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/monad-control-1.0.3.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/monad-control-1.0.3.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-monad-control
hs-libraries:         HSmonad-control-1.0.3.1-6BZrEcXVVy1ERiltg4JMsJ
depends:
    base-4.18.2.1 stm-2.5.1.0 transformers-0.6.1.0
    transformers-base-0.4.6-LskmwIYyClP9hZC0NTtvHv
    transformers-compat-0.7.2-LmnlcpbfHuuAOWEWPuyobH

haddock-interfaces:
    /usr/share/doc/haskell-monad-control/html/monad-control.haddock

haddock-html:         /usr/share/doc/haskell-monad-control/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

